#ifndef GST_UTILS_StringConv_hpp__
#define GST_UTILS_StringConv_hpp__

#include "buildspec.h"

#include <string>

namespace GST
{
namespace Utils
{
// Transforms src from UTF-8 encoding to Windows-1252 encoding
//
// Characters that cannot be represented in Windows-1252 encoding
// will replaced by '?'.
//
// Note: src has to be a 0-terminated cstring.
GST_API_EXPORT std::string fromUtf8ToWin1252(const char *src);
// Transforms src from UTF-8 encoding to Windows-1252 encoding
//
// Characters that cannot be represented in Windows-1252 encoding
// will replaced by '?'.
//
// Note: src needn't be 0-terminated and may include 0-bytes in its range.
GST_API_EXPORT std::string fromUtf8ToWin1252(const char *src, size_t size);
// Transforms src from UTF-8 encoding to Windows-1252 encoding
//
// Characters that cannot be represented in Windows-1252 encoding
// will replaced by '?'.
GST_API_EXPORT std::string fromUtf8ToWin1252(const std::string &src);
// Transforms src from Windows-1252 encoding to UTF-8 encoding
//
// All characters from Windows-1252 can be represented in the UTF-8
// encoding.
//
// Note: src has to be a 0-terminated cstring.
GST_API_EXPORT std::string fromWin1252ToUtf8(const char *src);
// Transforms src from Windows-1252 encoding to UTF-8 encoding
//
// All characters from Windows-1252 can be represented in the UTF-8
// encoding.
//
// Note: src needn't be 0-terminated and may include 0-bytes in its range.
GST_API_EXPORT std::string fromWin1252ToUtf8(const char *src, size_t size);
// Transforms src from Windows-1252 encoding to UTF-8 encoding
//
// All characters from Windows-1252 can be represented in the UTF-8
// encoding.
GST_API_EXPORT std::string fromWin1252ToUtf8(const std::string &src);
} // namespace Utils
} // namespace GST

#endif // GST_UTILS_StringConv_hpp__
